#ifndef LIB_H
#define LIB_H
//--------------------------------------------------------------------------------------------------------
#define OK				0x00
#define FAIL			0x01
#define WRITECOMMFAIL	0x02
#define READCOMMFAIL	0x03
#define READTIMEOUT		0x04
#define FORMATWRONG		0x05 
//--------------------------------------------------------------------------------------------------------
#define MF3_CREDIT					0x0C
#define MF3_DEBIT					0xDC
#define MF3_LIMITEDCREDIT			0x1C

#define MF3_COMMITTRANS				0xC7
#define MF3_ABORTTRANS				0xA7
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int LRC(unsigned short int len,char *buff);
extern "C" __declspec(dllexport) int open(int port,long baundrate);
extern "C" __declspec(dllexport) int openhid(unsigned short vendor_id, unsigned short product_id, wchar_t *serial_number);
extern "C" __declspec(dllexport) int closehid(void);
extern "C" __declspec(dllexport) int close(void);
extern "C" __declspec(dllexport) int baud(long baundrate);
extern "C" __declspec(dllexport) int timeout(int time);
extern "C" __declspec(dllexport) int QueueUartData(unsigned char *relen,unsigned char *redata);
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int SetBuzzer(unsigned char ucRates,unsigned char ucTimes) ;
extern "C" __declspec(dllexport) int SetLed(unsigned char ucRates,unsigned char ucTimes) ;
extern "C" __declspec(dllexport) int SetUARTBaudRate(unsigned char ucRates) ;
extern "C" __declspec(dllexport) int GetReaderUID(unsigned char *relen,unsigned char *reuid) ;
extern "C" __declspec(dllexport) int SetANT(unsigned char ucAnt);
extern "C" __declspec(dllexport) int GetANT(unsigned char *ucAnt);
extern "C" __declspec(dllexport) int SetHalt(void);
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int PCD_Read_Flash(unsigned int adder,unsigned short length,unsigned char *outdata); 
extern "C" __declspec(dllexport) int PCD_Write_Flash(unsigned int adder,unsigned short length,unsigned char *indata);
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int PiccAuthKey(	unsigned char auth_mode,
													unsigned char addr,
													unsigned char *pSnr,
													unsigned char *pKey) ;
extern "C" __declspec(dllexport) int PiccPersonalize(unsigned char ucType);
extern "C" __declspec(dllexport) int PiccRead(unsigned char ucBlock, unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccWrite(unsigned char ucBlock,unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccITGRead(	unsigned char rst_ms,
													unsigned char req_mode,
													unsigned char sector_begin,
													unsigned char sector_much,
													unsigned char block_each,
													unsigned char auth_mode,
													unsigned char *pKey,
													unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccITGWrite(	unsigned char rst_ms,
													unsigned char req_mode,
													unsigned char sector_begin,
													unsigned char sector_much,
													unsigned char block_each,
													unsigned char auth_mode,
													unsigned char *pKey,
													unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccULWrite(unsigned char ucBlock,unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccInitVL(unsigned char ucBlock,unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccValueOper(	unsigned char ucOperMode, 
													unsigned char ucBlock,
													unsigned char *pValue, 
													unsigned char ucTransBlock);
extern "C" __declspec(dllexport) int PiccBackup(	unsigned char ucBlock,
													unsigned char ucTransBlock);
extern "C" __declspec(dllexport) int PiccReadValue(unsigned char ucBlock, unsigned char *pBuf);
extern "C" __declspec(dllexport) int PiccReset(unsigned char _1ms);
extern "C" __declspec(dllexport) int PiccActivateA(	unsigned char ucMode, 
													unsigned char ucReqCode, 
													unsigned char *pATQ, 
													unsigned char *pSAK,
													unsigned char *pUIDLen,       
													unsigned char *pUID     );
extern "C" __declspec(dllexport) int PiccADRcv( unsigned char ucMode,unsigned char ucReqTime);
extern "C" __declspec(dllexport) int PiccActivateB(	unsigned char ucMode, 
												    unsigned char ucCID,
													unsigned char ucAFI, 
													unsigned char ucMethod,
													unsigned char *pUIDLen,
													unsigned char *pUID);
extern "C" __declspec(dllexport) int PiccActivateCID(unsigned char ucRst, unsigned char *pINF);
extern "C" __declspec(dllexport) int PiccActivateCID2(unsigned char ucRst, unsigned char *pINF);
extern "C" __declspec(dllexport) int PiccActivateC(	unsigned char ucMode, 
													unsigned char ucMethod,
													unsigned char *pINFLen,
													unsigned char *pINF);
extern "C" __declspec(dllexport) int PiccRequestATS(unsigned char ucCID,
													unsigned char *pATSLen, 
													unsigned char *pATS);
extern "C" __declspec(dllexport) int PiccTPCL(	unsigned int usSendLen,
												unsigned char *pSendBuf, 		
												unsigned int *pRcvLen,
												unsigned char *pRcvBuf);
extern "C" __declspec(dllexport) int PiccTANSf(	unsigned int usSendLen,
												unsigned char *pSendBuf, 		
												unsigned int *pRcvLen,
												unsigned char *pRcvBuf);
extern "C" __declspec(dllexport) int PiccAutoRATS(unsigned char rats);
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int PiccULAuth(unsigned char *pKey);
extern "C" __declspec(dllexport) int PiccULSetKey(unsigned char *pKey);
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int DESGetDESVersion(unsigned char *relen,unsigned char *rebuf);
//
extern "C" __declspec(dllexport) int DESAuthenticate(unsigned char KeyNO,unsigned char *pKey);
extern "C" __declspec(dllexport) int DESChangKey(unsigned char KeyNo,unsigned char KeySettings,unsigned char *pNewKey,unsigned char *pOldKey);
extern "C" __declspec(dllexport) int DESGetKeyVersion(unsigned char KeyNO,unsigned char *pKeyVersion);
extern "C" __declspec(dllexport) int DESGetKeySetting(unsigned char *pKeySetting,unsigned char *pMaxKeyNum);
extern "C" __declspec(dllexport) int DESChangKeySetting(unsigned char KeySetting);
//
extern "C" __declspec(dllexport) int DESSelectApplication(long AID);
extern "C" __declspec(dllexport) int DESGetApplicationIDs(unsigned char *pAIDs,unsigned char *pAIDno);
extern "C" __declspec(dllexport) int DESDeleteApplication(unsigned long AID);
extern "C" __declspec(dllexport) int DESFormatPicc(void);
extern "C" __declspec(dllexport) int DESCreateApplication(unsigned long AID,unsigned char KeySetting,unsigned char KeyNo);
//
extern "C" __declspec(dllexport) int DESGetFileIDs(unsigned char *pIDs,unsigned char *pFileIDs);
extern "C" __declspec(dllexport) int DESCreateStdDataFile( unsigned char FileID,unsigned char ComSet,unsigned short AccessRights,unsigned short FileSize);
extern "C" __declspec(dllexport) int DESCreateBackupDataFile( unsigned char FileID,unsigned char ComSet,unsigned short AccessRights,unsigned short FileSize);
extern "C" __declspec(dllexport) int DESCreateValueFile( unsigned char FileID,unsigned char ComSet,unsigned short AccessRights,long LowerLimit,long UpperLimit,long Value,unsigned char LimitCredit);
extern "C" __declspec(dllexport) int DESCreateLinearRecordFile( unsigned char FileID,unsigned char ComSet,unsigned short AccessRights,unsigned short FileSize,unsigned short RecordsNum);
extern "C" __declspec(dllexport) int DESCreateCyclicRecordFile( unsigned char FileID,unsigned char ComSet,unsigned short AccessRights,unsigned short FileSize,unsigned short RecordsNum);
extern "C" __declspec(dllexport) int DESDeleteDESFile(unsigned char FileID);
extern "C" __declspec(dllexport) int DESGetFileSettings(unsigned char FileID,unsigned char *pInfoLen,unsigned char *pFileInfo);
extern "C" __declspec(dllexport) int DESChangeFileSettings(unsigned char FileID,unsigned char NewComSet,unsigned short NewAccessRights);
//
extern "C" __declspec(dllexport) int DESWriteData(unsigned char FileID,unsigned short Offset,unsigned short Length,unsigned char *pBuf);
extern "C" __declspec(dllexport) int DESReadData(unsigned char FileID,unsigned short Offset,unsigned short Length,unsigned char *pBuf,unsigned short *RcvLen);
extern "C" __declspec(dllexport) int DESGetValue(unsigned char FileID,long *Value);
extern "C" __declspec(dllexport) int DESOperateValue(unsigned char FileID,unsigned char ValueCommand,long Value);
extern "C" __declspec(dllexport) int DESWriteRecord(unsigned char FileID,unsigned short Offset,unsigned short Length,unsigned char *pBuf);
extern "C" __declspec(dllexport) int DESReadRecord(unsigned char FileID,unsigned short RecordNo,unsigned short RecordNum,unsigned char *pBuf,unsigned short *RcvLen);
extern "C" __declspec(dllexport) int DESClearRecordFile(unsigned char FileID);
extern "C" __declspec(dllexport) int DESTransaction(unsigned char Command);
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int IccPowerUp(	unsigned char usCardSlot,
													unsigned char *pRecLen,
													unsigned char *pRcvBuf);
extern "C" __declspec(dllexport) int IccPowerDn(	unsigned char usCardSlot );
extern "C" __declspec(dllexport) int IccAPDU (	unsigned char usCardSlot,
												unsigned int usSendLen,
												unsigned char *pSendBuf, 		
												unsigned int *pRcvLen,
												unsigned char *pRcvBuf);
extern "C" __declspec(dllexport) int IccChannal(	unsigned char usCardSlot,
													unsigned int usSendLen,
													unsigned char *pSendBuf,
													unsigned int *pRcvLen,
													unsigned char *pRcvBuf);
extern "C" __declspec(dllexport) int IccCheck_Pres (unsigned char usCardSlot, unsigned char *usStatus );
extern "C" __declspec(dllexport) int IccSetInitBaudrate (unsigned char usCardSlot,unsigned char ucRates );
//--------------------------------------------------------------------------------------------------------
extern "C" __declspec(dllexport) int ISO15693_Inventory(unsigned char flags,
														unsigned char AFI, 
														unsigned char masklengh, 
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Select(unsigned char flags,
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Stay_Quiet(unsigned char flags,
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Read_Block(unsigned char flags,
														unsigned char blnr, 
														unsigned char nbl, 
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Write_Block(unsigned char flags,
														unsigned char blnr, 
														unsigned char nbl, 
														unsigned char *uid, 
														unsigned char *dtw, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Lock_Block(unsigned char flags,
														unsigned char blnr, 
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Write_AFI(unsigned char flags,
														unsigned char AFI, 
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Lock_AFI(unsigned char flags,
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Write_DSFID(unsigned char flags,
														unsigned char DSFID, 
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Lock_DSFID(unsigned char flags,
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
extern "C" __declspec(dllexport) int ISO15693_Get_SysInfor(unsigned char flags,
														unsigned char *uid, 
														unsigned short *resplen, 
														unsigned char *resp);
//--------------------------------------------------------------------------------------------------------
//
#endif